-- [ALT]            IGNORE ON DB-CREATE IF NOT DB-VER = '%8.3%' : DB-Erstellung im Prodat überspringt diese Datei (TDBCreateForm.btReloadXXXClick)
-- [NEU 2019-06-20] IGNORE ON DB-CREATE IF NOT EXISTS CAST NUMERIC TO TEXT : DB-Erstellung im Prodat überspringt diese Datei (TDBCreateForm.btReloadXXXClick)

CREATE SCHEMA IF NOT EXISTS TSystem; -- zur Verwendung copynpaste bei neuen DB

DO $$
DECLARE
  version int;
BEGIN

    -- keine casts wenn version größer pg 10
    version :=
      (CASE WHEN split_part(s,'.',1)::integer > 9 THEN
        split_part(s,'.',1) || '0' 
    ELSE 
      split_part(s,'.', 1) || split_part(s,'.', 2) 
    END)::INT
      FROM substring(version(), E'PostgreSQL ([0-9\.]+)') AS s;
    
    -- IF ( version > 100 ) THEN
    --   RETURN;
    -- END IF;

    BEGIN       
        CREATE OR REPLACE FUNCTION tsystem.implicit__text(integer) RETURNS text STRICT IMMUTABLE LANGUAGE SQL AS 'SELECT textin(int4out($1));';
        CREATE CAST (integer AS text) WITH FUNCTION tsystem.implicit__text(integer) AS IMPLICIT;
    EXCEPTION WHEN OTHERS THEN
        RAISE WARNING '%', sqlerrm;
    END;
    BEGIN
        CREATE OR REPLACE FUNCTION tsystem.implicit__text(smallint) RETURNS text STRICT IMMUTABLE LANGUAGE SQL AS 'SELECT textin(int2out($1));';
        CREATE CAST (smallint AS text) WITH FUNCTION tsystem.implicit__text(smallint) AS IMPLICIT;
    EXCEPTION WHEN OTHERS THEN
        RAISE WARNING '%', sqlerrm;
    END; 
    BEGIN   
        CREATE OR REPLACE FUNCTION tsystem.implicit__text(date) RETURNS text STRICT IMMUTABLE LANGUAGE SQL AS 'SELECT textin(date_out($1));';
        CREATE CAST (date AS text) WITH FUNCTION tsystem.implicit__text(date) AS IMPLICIT;
    EXCEPTION WHEN OTHERS THEN
        RAISE WARNING '%', sqlerrm;
    END; 
    BEGIN   
        CREATE OR REPLACE FUNCTION tsystem.implicit__text(bigint) RETURNS text STRICT IMMUTABLE LANGUAGE SQL AS 'SELECT textin(int8out($1));';
        CREATE CAST (bigint AS text) WITH FUNCTION tsystem.implicit__text(bigint) AS IMPLICIT;
    EXCEPTION WHEN OTHERS THEN
        RAISE WARNING '%', sqlerrm;
    END; 
    BEGIN           
        CREATE OR REPLACE FUNCTION tsystem.implicit__text(numeric) RETURNS text STRICT IMMUTABLE LANGUAGE SQL AS 'SELECT textin(numeric_out($1));';
        CREATE CAST (numeric AS text) WITH FUNCTION tsystem.implicit__text(numeric) AS IMPLICIT;
    EXCEPTION WHEN OTHERS THEN
        RAISE WARNING '%', sqlerrm;
    END; 
    BEGIN   
        CREATE OR REPLACE FUNCTION tsystem.implicit__text(time with time zone) RETURNS text STRICT IMMUTABLE LANGUAGE SQL AS 'SELECT textin(timetz_out($1));';
        CREATE CAST (time with time zone AS text) WITH FUNCTION tsystem.implicit__text(time with time zone) AS IMPLICIT;
    EXCEPTION WHEN OTHERS THEN
        RAISE WARNING '%', sqlerrm;
    END; 
    BEGIN   
        CREATE OR REPLACE FUNCTION tsystem.implicit__text(time without time zone) RETURNS text STRICT IMMUTABLE LANGUAGE SQL AS 'SELECT textin(time_out($1));';
        CREATE CAST (time without time zone AS text) WITH FUNCTION tsystem.implicit__text(time without time zone) AS IMPLICIT;
    EXCEPTION WHEN OTHERS THEN
        RAISE WARNING '%', sqlerrm;
    END;    
    
    BEGIN   
        CREATE OR REPLACE FUNCTION tsystem.implicit__text(oid) RETURNS text STRICT IMMUTABLE LANGUAGE SQL AS 'SELECT textin( int4out($1::int) );';
        CREATE CAST ( oid AS text ) WITH FUNCTION tsystem.implicit__text( oid ) AS IMPLICIT;
    EXCEPTION WHEN OTHERS THEN
        RAISE WARNING '%', sqlerrm;
    END;    

END $$ language plpgsql;

--
DELETE FROM pg_operator WHERE oprcode = 'anytextcat'::regproc;
DELETE FROM pg_operator WHERE oprcode = 'textanycat'::regproc;
